### Server

set ::MAC_ARCH "Intel_64"

cd [file dirname [info script]]
cd .. ;# => Resources
cd .. ;# => Contents
cd .. ;# => App folder
set ::HOME [pwd]
set ::MAC_APP_FOLDER [pwd]

proc mac_startup {} {
	set ::RESOURCES_PATH [file join $::HOME Contents lib resources.dylib]
	if {![file exists $::RESOURCES_PATH]} {
		# figure out the source dir
		set exe [info nameofexecutable]
		set home [file normalize ~]
		set from_fw4_dev [string trimleft $exe $home]
		if {[string range $from_fw4_dev 0 6] != "fw4_dev"} {
			error "When running from source, the app must be located under fw4_dev.xx"
		}
		set fw4_dev [file join $home [string range $from_fw4_dev 0 [string first "/" $from_fw4_dev]-1]]
		foreach dir [list $fw4_dev] {
			if {[file isdirectory $dir]} {
				source [file join $dir env os_mac mac_server_run_from_source.t]
				mac_copy_source_files $dir
				break
			}
		}
	}

	source [file join $::HOME Contents Resources Scripts mac_server_init.t]
}

set ::JENKINS_BUILD 1;mac_startup;
